##
## Status and physiological significance of circulating adiponectin in the very old and centenarians: an observational study
## Sasaki et al.
##

library(ggplot2)
library (dplyr)
library (exactRankTests)

## Fig3a, 3b

## import data 
data <- read.csv("Figs1-3_SourceData1.csv")
## define data type
data$sex <- as.factor (data$sex)
xtabs (~group+sex, data)
summary (data)


##
## categorize DM (medication or insulin inj or HbA1C ≥ 6.5)
## 

data <- data %>% dplyr::mutate (DM = case_when(
  HbA1C < 6.5 & DM_medi.insu == "0" ~ "0",
  HbA1C >= 6.5 & DM_medi.insu == "0" ~ "1", 
  HbA1C < 6.5 & DM_medi.insu == "1" ~ "1", 
  HbA1C >= 6.5 & DM_medi.insu == "1" ~ "1", 
))

xtabs (~ DM + group + sex,data)


## fig 3a
## VeryOld men
tmp <- data %>% dplyr::filter ((sex== "0") & (group == "VeryOld")) %>% select (DM, Adiponectin) %>% na.omit
xtabs (~DM, tmp)

g <- ggplot(tmp , aes(x=DM, y= Adiponectin))
g <- g + geom_violin( trim=T,fill="#666B6C",linetype="blank",alpha=I(1/3), scale="area") 
g <- g + geom_boxplot (width=.1,fill="blue", alpha=I(1/3),outlier.color =NA)  
g <- g + geom_jitter (size = 0.3, width = 0.2, height = 0.0, alpha = 0.5)
g <- g + scale_x_discrete (labels=c ("non DM", "DM"),limits = c("0","1"))
g <- g + scale_y_continuous (limits = c(0,100))
g <- g + theme_bw() # 背景を論文用の白黒に
g <- g + theme (panel.background = element_rect(color="black", size=1 )) #枠を太く
g <- g + theme(axis.title.x = element_text(size=15),axis.title.y = element_text(size=15)) #軸ラベルのフォントサイズ調節。
g <- g + ylab ("cHMW adiponectin")
g <- g + xlab ("DM")
g <- g + ggtitle ("Very old men")
plot(g) 

vx <- tmp$Adiponectin [tmp$DM == "0" ]
vy <- tmp$Adiponectin [tmp$DM == "1" ]
wilcox.exact(x=vx,y=vy,paired=F)


## fig 3a
## VeryOld female
tmp <- data %>% dplyr::filter ((sex== "1") & (group == "VeryOld")) %>% select (DM, Adiponectin) %>% na.omit
xtabs (~DM, tmp)

g <- ggplot(tmp , aes(DM, Adiponectin))
g <- g + geom_violin( trim=T,fill="#666B6C",linetype="blank",alpha=I(1/3), scale="area") 
g <- g + geom_boxplot (width=.1,fill="red", alpha=I(1/3),outlier.color =NA)  
g <- g + geom_jitter (size = 0.3, width = 0.2, height = 0.0, alpha = 0.5)
g <- g + scale_x_discrete (labels=c ("non DM", "DM"),limits = c("0","1"))
g <- g + scale_y_continuous (limits = c(0,100))
g <- g + theme_bw() # 背景を論文用の白黒に
g <- g + theme (panel.background = element_rect(color="black", size=1 )) #枠を太く
g <- g + theme(axis.title.x = element_text(size=15),axis.title.y = element_text(size=15)) #軸ラベルのフォントサイズ調節。
g <- g + ylab ("cHMW adiponectin")
g <- g + xlab ("DM")
g <- g + ggtitle ("Very old women")
plot(g) 

vx <- tmp$Adiponectin [tmp$DM == "0" ] %>% na.omit
vy <- tmp$Adiponectin [tmp$DM == "1" ] %>% na.omit
wilcox.exact(x=vx,y=vy,paired=F)



## fig 3b
## Cent male
tmp <- data %>% dplyr::filter ((sex== "0") & (group == "Cent")) %>% select (DM, Adiponectin) %>% na.omit
xtabs (~DM, tmp)

g <- ggplot(tmp , aes(DM, Adiponectin))
g <- g + geom_violin( trim=T,fill="#666B6C",linetype="blank",alpha=I(1/3), scale="area") 
g <- g + geom_boxplot (width=.1,fill="blue", alpha=I(1/3),outlier.color =NA)  # #008000 == green
g <- g + geom_jitter (size = 0.3, width = 0.2, height = 0.0, alpha = 0.5)
g <- g + scale_x_discrete (labels=c ("non DM", "DM"),limits = c("0","1"))
g <- g + scale_y_continuous (limits = c(0,100))
g <- g + theme_bw() # 背景を論文用の白黒に
g <- g + theme (panel.background = element_rect(color="black", size=1 )) #枠を太く
g <- g + theme(axis.title.x = element_text(size=15),axis.title.y = element_text(size=15)) #軸ラベルのフォントサイズ調節。
g <- g + ylab ("cHMW adiponectin")
g <- g + xlab ("DM")
g <- g + ggtitle ("Centenarian men")
plot(g) 

vx <- tmp$Adiponectin [tmp$DM == "0" ] %>% na.omit
vy <- tmp$Adiponectin [tmp$DM == "1" ] %>% na.omit
wilcox.exact(x=vx,y=vy,paired=F)


## fig 3b
## Cent female
tmp <- data %>% dplyr::filter ((sex== "1") & (group == "Cent")) %>% select (DM, Adiponectin) %>% na.omit
xtabs (~DM, tmp)

g <- ggplot(tmp , aes(DM, Adiponectin))
g <- g + geom_violin( trim=T,fill="#666B6C",linetype="blank",alpha=I(1/3), scale="area") 
g <- g + geom_boxplot (width=.1,fill="red", alpha=I(1/3),outlier.color =NA)  # #008000 == green
g <- g + geom_jitter (size = 0.3, width = 0.2, height = 0.0, alpha = 0.5)
g <- g + scale_x_discrete (labels=c ("non DM", "DM"),limits = c("0","1"))
g <- g + scale_y_continuous (limits = c(0,100))
g <- g + theme_bw() # 背景を論文用の白黒に
g <- g + theme (panel.background = element_rect(color="black", size=1 )) #枠を太く
g <- g + theme(axis.title.x = element_text(size=15),axis.title.y = element_text(size=15)) #軸ラベルのフォントサイズ調節。
g <- g + ylab ("cHMW adiponectin")
g <- g + xlab ("DM")
g <- g + ggtitle ("Centenarian women")
plot(g) 

vx <- tmp$Adiponectin [tmp$DM == "0" ] %>% na.omit
vy <- tmp$Adiponectin [tmp$DM == "1" ] %>% na.omit
wilcox.exact(x=vx,y=vy,paired=F)


